/*****************************************************************************
*  LPC154x Center aligned demo program for LPCXpresso board
*
*  1. Use SCT3 timer to generate a PWM output signal @ SCT3_OUT0
*  2. Every time P0_17 (sw1) goes high to low increase the duty cycle.
*  3. Every time P1_9  (sw2) goes high to low decrease the duty cycle.
*  4. SCT3_OUT0 is connected to P1_1 (blue LED).
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT3_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/
void SCT3_Init(void)
{

	Chip_SCT_Init(LPC_SCT3);			                   					// enable the SCT3 clock

	Chip_SCT_Config(LPC_SCT3, SCT_CONFIG_16BIT_COUNTER	|	 				// two 16-bit timers
							  SCT_CONFIG_AUTOLIMIT_L	);					// auto limit

	Chip_SCT_SetControl(LPC_SCT3, SCT_CTRL_BIDIR_L(1)	|
								  SCT_CTRL_PRE_L(5)		);					// Bidir mode, prescaler = 6, SCT clock = 2 MHz

	Chip_SCT_SetMatchCount(LPC_SCT3, SCT_MATCH_0,	9);						// match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT3, SCT_MATCH_0, 9);

	Chip_SCT_SetMatchCount(LPC_SCT3, SCT_MATCH_1,	5);						// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT3, SCT_MATCH_1, 5);


	Chip_SCT_EventState(LPC_SCT3, SCT_EVENT_0, ENABLE_ALL_STATES);			// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT3, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1 |
                                                                        SCT_COMBMODE_MATCH	));		// match 1 condition only

	Chip_SCT_ClearOutput(LPC_SCT3, SCT_OUTPUT_0, SCT_EVT_0 );				// event 0 will clear SCT3_OUT0

	Chip_SCT_SetoutputdirControl(LPC_SCT3, SCT_EVT_0);						// reverse output 0 set when down counting



    Chip_SCT_ClearControl(LPC_SCT3, SCT_CTRL_HALT_L);						// start timer
}


int main(void)
{

	static uint8_t trgsw1 = 1;
	static uint8_t trgsw2 = 1;


  	SystemCoreClockUpdate();
  	Board_Init();


  	Chip_Clock_EnablePeriphClock(	(CHIP_SYSCTL_CLOCK_T) ( SYSCTL_CLOCK_SWM	  |					//enable SWM clock
                                                          SYSCTL_CLOCK_GPIO0	|					// enable clock to GPIO port 0 and 1
                                                          SYSCTL_CLOCK_GPIO1	));
  	Chip_SWM_MovablePortPinAssign(SWM_SCT3_OUT0_O , 1, 1);					// P0_1 is SCT3_OUT0

    SCT3_Init();                                           					// Initialize SCT3

    while (1)                                              					// loop forever
    {
		if (!Chip_GPIO_GetPinState(LPC_GPIO, 0,17) && trgsw1)       		// P0_17 (sw1) high to low?
		{
			trgsw1 = 0;                                        				// trigger sw1 low
			if (LPC_SCT3->MATCHREL[1].L < 9)
				LPC_SCT3->MATCHREL[1].L ++;                    				// increase PWM dutycycle
		}
		else if (Chip_GPIO_GetPinState(LPC_GPIO, 0,17) && !trgsw1)  		// P0_17 (sw1) low to high?
		{
			trgsw1 = 1;                                        				// trigger sw1 high
		}

		if (!Chip_GPIO_GetPinState(LPC_GPIO, 1,9) && trgsw2)       			// P1_9 (sw3) high to low?
		{
			trgsw2 = 0;                                        				// trigger sw3 low
			if (LPC_SCT3->MATCHREL[1].L > 0)
				LPC_SCT3->MATCHREL[1].L --;                    				// decrease PWM dutycycle
		}
		else if (Chip_GPIO_GetPinState(LPC_GPIO, 1,9) && !trgsw2)  			// P1_9 (sw3) low to high?
		{
			trgsw2 = 1;                                        				// trigger sw3 high
		}
    }
}
